<?php

namespace App\Http\Controllers;

use App\Models\Section;
use Illuminate\Http\Request;
use Inertia\Inertia;

class MySectionsController extends Controller
{
    public function index(Request $request)
    {
        $user = $request->user();

        // Get user's sections with pagination
        $sections = Section::where('user_id', $user->id)
            ->with(['versions', 'user', 'category'])
            ->orderBy('created_at', 'desc')
            ->paginate(12);

        return Inertia::render('sections/my-sections', [
            'sections' => $sections,
        ]);
    }
}
