<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreSectionRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return $this->user() !== null;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name' => ['required', 'string', 'max:255'],
            'description' => ['nullable', 'string'],
            'category' => ['required', 'string', 'max:255'],
            'tags' => ['nullable', 'array'],
            'tags.*' => ['string'],
            'thumbnail' => ['nullable', 'image', 'max:2048'],
            'versions' => ['required', 'array', 'min:1'],
            'versions.*.framework' => ['required', 'in:html,react,vue,angular'],
            'versions.*.styling' => ['required', 'in:tailwind,bootstrap'],
            'versions.*.code' => ['required', 'string'],
            'versions.*.dependencies' => ['nullable', 'array'],
            'versions.*.notes' => ['nullable', 'string'],
        ];
    }

    /**
     * Get custom error messages for validation rules.
     */
    public function messages(): array
    {
        return [
            'name.required' => 'Section name is required',
            'category.required' => 'Please select a category',
            'versions.required' => 'At least one version is required',
            'versions.min' => 'At least one version is required',
            'versions.*.framework.required' => 'Framework is required for each version',
            'versions.*.framework.in' => 'Framework must be html, react, vue, or angular',
            'versions.*.styling.required' => 'Styling framework is required for each version',
            'versions.*.styling.in' => 'Styling must be tailwind or bootstrap',
            'versions.*.code.required' => 'Code is required for each version',
        ];
    }
}
