<?php

namespace App\Providers;

use Illuminate\Support\Facades\Gate;
use Illuminate\Support\ServiceProvider;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        Gate::define('approve', function ($user, $modelClass) {
            return $user->isAdmin();
        });

        Gate::define('manage-categories', function ($user) {
            return $user->isAdmin() || $user->isContributor();
        });
    }
}
