<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('section_versions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('section_id')->constrained()->onDelete('cascade');
            $table->enum('framework', ['html', 'react', 'vue', 'angular']);
            $table->enum('styling', ['tailwind', 'bootstrap'])->default('tailwind');
            $table->longText('code'); // The actual code content
            $table->json('dependencies')->nullable(); // Required packages/libraries
            $table->text('notes')->nullable(); // Implementation notes
            $table->string('version')->default('1.0.0');
            $table->boolean('is_active')->default(true);
            $table->timestamps();

            $table->unique(['section_id', 'framework', 'styling']);
            $table->index('section_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('section_versions');
    }
};
