<?php

namespace Database\Seeders;

use App\Models\Category;
use Illuminate\Database\Seeder;

class CategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $categories = [
            [
                'name' => 'Hero',
                'slug' => 'hero',
                'description' => 'Hero sections and landing page headers',
                'icon' => 'Rocket',
                'color' => '#3b82f6',
            ],
            [
                'name' => 'About',
                'slug' => 'about',
                'description' => 'About sections and company information',
                'icon' => 'Info',
                'color' => '#8b5cf6',
            ],
            [
                'name' => 'Contact',
                'slug' => 'contact',
                'description' => 'Contact forms and contact sections',
                'icon' => 'Mail',
                'color' => '#10b981',
            ],
            [
                'name' => 'Team',
                'slug' => 'team',
                'description' => 'Team member grids and showcases',
                'icon' => 'Users',
                'color' => '#f59e0b',
            ],
            [
                'name' => 'Features',
                'slug' => 'features',
                'description' => 'Feature cards and feature lists',
                'icon' => 'Sparkles',
                'color' => '#ec4899',
            ],
            [
                'name' => 'Blogs',
                'slug' => 'blogs',
                'description' => 'Blog grids and blog cards',
                'icon' => 'BookOpen',
                'color' => '#6366f1',
            ],
            [
                'name' => 'Testimonials',
                'slug' => 'testimonials',
                'description' => 'Testimonial sections and reviews',
                'icon' => 'MessageSquare',
                'color' => '#14b8a6',
            ],
            [
                'name' => 'Pricing',
                'slug' => 'pricing',
                'description' => 'Pricing tables and pricing cards',
                'icon' => 'DollarSign',
                'color' => '#f97316',
            ],
            [
                'name' => 'FAQ',
                'slug' => 'faq',
                'description' => 'FAQ sections and accordion components',
                'icon' => 'HelpCircle',
                'color' => '#06b6d4',
            ],
            [
                'name' => 'Footer',
                'slug' => 'footer',
                'description' => 'Footer sections',
                'icon' => 'Layout',
                'color' => '#64748b',
            ],
            [
                'name' => 'Navbar',
                'slug' => 'navbar',
                'description' => 'Navigation bars and headers',
                'icon' => 'Menu',
                'color' => '#0ea5e9',
            ],
            [
                'name' => 'CTA',
                'slug' => 'cta',
                'description' => 'Call-to-action sections',
                'icon' => 'Zap',
                'color' => '#ef4444',
            ],
        ];

        foreach ($categories as $category) {
            Category::firstOrCreate(
                ['slug' => $category['slug']],
                $category
            );
        }
    }
}
