import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../../wayfinder'
/**
* @see \App\Http\Controllers\MySectionsController::index
* @see app/Http/Controllers/MySectionsController.php:11
* @route '/my-sections'
*/
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/my-sections',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\MySectionsController::index
* @see app/Http/Controllers/MySectionsController.php:11
* @route '/my-sections'
*/
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\MySectionsController::index
* @see app/Http/Controllers/MySectionsController.php:11
* @route '/my-sections'
*/
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\MySectionsController::index
* @see app/Http/Controllers/MySectionsController.php:11
* @route '/my-sections'
*/
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\MySectionsController::index
* @see app/Http/Controllers/MySectionsController.php:11
* @route '/my-sections'
*/
const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\MySectionsController::index
* @see app/Http/Controllers/MySectionsController.php:11
* @route '/my-sections'
*/
indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\MySectionsController::index
* @see app/Http/Controllers/MySectionsController.php:11
* @route '/my-sections'
*/
indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

const MySectionsController = { index }

export default MySectionsController