import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../../../wayfinder'
/**
* @see \App\Http\Controllers\SectionController::index
* @see app/Http/Controllers/SectionController.php:17
* @route '/sections'
*/
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/sections',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SectionController::index
* @see app/Http/Controllers/SectionController.php:17
* @route '/sections'
*/
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\SectionController::index
* @see app/Http/Controllers/SectionController.php:17
* @route '/sections'
*/
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SectionController::index
* @see app/Http/Controllers/SectionController.php:17
* @route '/sections'
*/
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SectionController::index
* @see app/Http/Controllers/SectionController.php:17
* @route '/sections'
*/
const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SectionController::index
* @see app/Http/Controllers/SectionController.php:17
* @route '/sections'
*/
indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SectionController::index
* @see app/Http/Controllers/SectionController.php:17
* @route '/sections'
*/
indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: index.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

index.form = indexForm

/**
* @see \App\Http\Controllers\SectionController::create
* @see app/Http/Controllers/SectionController.php:152
* @route '/sections/create'
*/
export const create = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})

create.definition = {
    methods: ["get","head"],
    url: '/sections/create',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SectionController::create
* @see app/Http/Controllers/SectionController.php:152
* @route '/sections/create'
*/
create.url = (options?: RouteQueryOptions) => {
    return create.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\SectionController::create
* @see app/Http/Controllers/SectionController.php:152
* @route '/sections/create'
*/
create.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SectionController::create
* @see app/Http/Controllers/SectionController.php:152
* @route '/sections/create'
*/
create.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: create.url(options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SectionController::create
* @see app/Http/Controllers/SectionController.php:152
* @route '/sections/create'
*/
const createForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SectionController::create
* @see app/Http/Controllers/SectionController.php:152
* @route '/sections/create'
*/
createForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url(options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SectionController::create
* @see app/Http/Controllers/SectionController.php:152
* @route '/sections/create'
*/
createForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: create.url({
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

create.form = createForm

/**
* @see \App\Http\Controllers\SectionController::store
* @see app/Http/Controllers/SectionController.php:166
* @route '/sections'
*/
export const store = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/sections',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SectionController::store
* @see app/Http/Controllers/SectionController.php:166
* @route '/sections'
*/
store.url = (options?: RouteQueryOptions) => {
    return store.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\SectionController::store
* @see app/Http/Controllers/SectionController.php:166
* @route '/sections'
*/
store.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SectionController::store
* @see app/Http/Controllers/SectionController.php:166
* @route '/sections'
*/
const storeForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SectionController::store
* @see app/Http/Controllers/SectionController.php:166
* @route '/sections'
*/
storeForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: store.url(options),
    method: 'post',
})

store.form = storeForm

/**
* @see \App\Http\Controllers\SectionController::edit
* @see app/Http/Controllers/SectionController.php:241
* @route '/sections/{section}/edit'
*/
export const edit = (args: { section: number | { id: number } } | [section: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

edit.definition = {
    methods: ["get","head"],
    url: '/sections/{section}/edit',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SectionController::edit
* @see app/Http/Controllers/SectionController.php:241
* @route '/sections/{section}/edit'
*/
edit.url = (args: { section: number | { id: number } } | [section: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { section: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { section: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            section: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        section: typeof args.section === 'object'
        ? args.section.id
        : args.section,
    }

    return edit.definition.url
            .replace('{section}', parsedArgs.section.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SectionController::edit
* @see app/Http/Controllers/SectionController.php:241
* @route '/sections/{section}/edit'
*/
edit.get = (args: { section: number | { id: number } } | [section: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SectionController::edit
* @see app/Http/Controllers/SectionController.php:241
* @route '/sections/{section}/edit'
*/
edit.head = (args: { section: number | { id: number } } | [section: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: edit.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SectionController::edit
* @see app/Http/Controllers/SectionController.php:241
* @route '/sections/{section}/edit'
*/
const editForm = (args: { section: number | { id: number } } | [section: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SectionController::edit
* @see app/Http/Controllers/SectionController.php:241
* @route '/sections/{section}/edit'
*/
editForm.get = (args: { section: number | { id: number } } | [section: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SectionController::edit
* @see app/Http/Controllers/SectionController.php:241
* @route '/sections/{section}/edit'
*/
editForm.head = (args: { section: number | { id: number } } | [section: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: edit.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

edit.form = editForm

/**
* @see \App\Http\Controllers\SectionController::update
* @see app/Http/Controllers/SectionController.php:261
* @route '/sections/{section}'
*/
export const update = (args: { section: number | { id: number } } | [section: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

update.definition = {
    methods: ["put"],
    url: '/sections/{section}',
} satisfies RouteDefinition<["put"]>

/**
* @see \App\Http\Controllers\SectionController::update
* @see app/Http/Controllers/SectionController.php:261
* @route '/sections/{section}'
*/
update.url = (args: { section: number | { id: number } } | [section: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { section: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { section: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            section: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        section: typeof args.section === 'object'
        ? args.section.id
        : args.section,
    }

    return update.definition.url
            .replace('{section}', parsedArgs.section.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SectionController::update
* @see app/Http/Controllers/SectionController.php:261
* @route '/sections/{section}'
*/
update.put = (args: { section: number | { id: number } } | [section: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'put'> => ({
    url: update.url(args, options),
    method: 'put',
})

/**
* @see \App\Http\Controllers\SectionController::update
* @see app/Http/Controllers/SectionController.php:261
* @route '/sections/{section}'
*/
const updateForm = (args: { section: number | { id: number } } | [section: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SectionController::update
* @see app/Http/Controllers/SectionController.php:261
* @route '/sections/{section}'
*/
updateForm.put = (args: { section: number | { id: number } } | [section: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: update.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'PUT',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

update.form = updateForm

/**
* @see \App\Http\Controllers\SectionController::resubmit
* @see app/Http/Controllers/SectionController.php:349
* @route '/sections/{section}/resubmit'
*/
export const resubmit = (args: { section: number | { id: number } } | [section: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: resubmit.url(args, options),
    method: 'post',
})

resubmit.definition = {
    methods: ["post"],
    url: '/sections/{section}/resubmit',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\SectionController::resubmit
* @see app/Http/Controllers/SectionController.php:349
* @route '/sections/{section}/resubmit'
*/
resubmit.url = (args: { section: number | { id: number } } | [section: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { section: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { section: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            section: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        section: typeof args.section === 'object'
        ? args.section.id
        : args.section,
    }

    return resubmit.definition.url
            .replace('{section}', parsedArgs.section.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SectionController::resubmit
* @see app/Http/Controllers/SectionController.php:349
* @route '/sections/{section}/resubmit'
*/
resubmit.post = (args: { section: number | { id: number } } | [section: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: resubmit.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SectionController::resubmit
* @see app/Http/Controllers/SectionController.php:349
* @route '/sections/{section}/resubmit'
*/
const resubmitForm = (args: { section: number | { id: number } } | [section: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: resubmit.url(args, options),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SectionController::resubmit
* @see app/Http/Controllers/SectionController.php:349
* @route '/sections/{section}/resubmit'
*/
resubmitForm.post = (args: { section: number | { id: number } } | [section: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: resubmit.url(args, options),
    method: 'post',
})

resubmit.form = resubmitForm

/**
* @see \App\Http\Controllers\SectionController::destroy
* @see app/Http/Controllers/SectionController.php:375
* @route '/sections/{section}'
*/
export const destroy = (args: { section: number | { id: number } } | [section: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

destroy.definition = {
    methods: ["delete"],
    url: '/sections/{section}',
} satisfies RouteDefinition<["delete"]>

/**
* @see \App\Http\Controllers\SectionController::destroy
* @see app/Http/Controllers/SectionController.php:375
* @route '/sections/{section}'
*/
destroy.url = (args: { section: number | { id: number } } | [section: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { section: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'id' in args) {
        args = { section: args.id }
    }

    if (Array.isArray(args)) {
        args = {
            section: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        section: typeof args.section === 'object'
        ? args.section.id
        : args.section,
    }

    return destroy.definition.url
            .replace('{section}', parsedArgs.section.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SectionController::destroy
* @see app/Http/Controllers/SectionController.php:375
* @route '/sections/{section}'
*/
destroy.delete = (args: { section: number | { id: number } } | [section: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteDefinition<'delete'> => ({
    url: destroy.url(args, options),
    method: 'delete',
})

/**
* @see \App\Http\Controllers\SectionController::destroy
* @see app/Http/Controllers/SectionController.php:375
* @route '/sections/{section}'
*/
const destroyForm = (args: { section: number | { id: number } } | [section: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

/**
* @see \App\Http\Controllers\SectionController::destroy
* @see app/Http/Controllers/SectionController.php:375
* @route '/sections/{section}'
*/
destroyForm.delete = (args: { section: number | { id: number } } | [section: number | { id: number } ] | number | { id: number }, options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
    action: destroy.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'DELETE',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'post',
})

destroy.form = destroyForm

/**
* @see \App\Http\Controllers\SectionController::getCode
* @see app/Http/Controllers/SectionController.php:125
* @route '/sections/{section}/versions/{version}/code'
*/
export const getCode = (args: { section: number | { id: number }, version: number | { id: number } } | [section: number | { id: number }, version: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: getCode.url(args, options),
    method: 'get',
})

getCode.definition = {
    methods: ["get","head"],
    url: '/sections/{section}/versions/{version}/code',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SectionController::getCode
* @see app/Http/Controllers/SectionController.php:125
* @route '/sections/{section}/versions/{version}/code'
*/
getCode.url = (args: { section: number | { id: number }, version: number | { id: number } } | [section: number | { id: number }, version: number | { id: number } ], options?: RouteQueryOptions) => {
    if (Array.isArray(args)) {
        args = {
            section: args[0],
            version: args[1],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        section: typeof args.section === 'object'
        ? args.section.id
        : args.section,
        version: typeof args.version === 'object'
        ? args.version.id
        : args.version,
    }

    return getCode.definition.url
            .replace('{section}', parsedArgs.section.toString())
            .replace('{version}', parsedArgs.version.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SectionController::getCode
* @see app/Http/Controllers/SectionController.php:125
* @route '/sections/{section}/versions/{version}/code'
*/
getCode.get = (args: { section: number | { id: number }, version: number | { id: number } } | [section: number | { id: number }, version: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: getCode.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SectionController::getCode
* @see app/Http/Controllers/SectionController.php:125
* @route '/sections/{section}/versions/{version}/code'
*/
getCode.head = (args: { section: number | { id: number }, version: number | { id: number } } | [section: number | { id: number }, version: number | { id: number } ], options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: getCode.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SectionController::getCode
* @see app/Http/Controllers/SectionController.php:125
* @route '/sections/{section}/versions/{version}/code'
*/
const getCodeForm = (args: { section: number | { id: number }, version: number | { id: number } } | [section: number | { id: number }, version: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: getCode.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SectionController::getCode
* @see app/Http/Controllers/SectionController.php:125
* @route '/sections/{section}/versions/{version}/code'
*/
getCodeForm.get = (args: { section: number | { id: number }, version: number | { id: number } } | [section: number | { id: number }, version: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: getCode.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SectionController::getCode
* @see app/Http/Controllers/SectionController.php:125
* @route '/sections/{section}/versions/{version}/code'
*/
getCodeForm.head = (args: { section: number | { id: number }, version: number | { id: number } } | [section: number | { id: number }, version: number | { id: number } ], options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: getCode.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

getCode.form = getCodeForm

/**
* @see \App\Http\Controllers\SectionController::show
* @see app/Http/Controllers/SectionController.php:88
* @route '/sections/{section}'
*/
export const show = (args: { section: string | number | { slug: string | number } } | [section: string | number | { slug: string | number } ] | string | number | { slug: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

show.definition = {
    methods: ["get","head"],
    url: '/sections/{section}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\SectionController::show
* @see app/Http/Controllers/SectionController.php:88
* @route '/sections/{section}'
*/
show.url = (args: { section: string | number | { slug: string | number } } | [section: string | number | { slug: string | number } ] | string | number | { slug: string | number }, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { section: args }
    }

    if (typeof args === 'object' && !Array.isArray(args) && 'slug' in args) {
        args = { section: args.slug }
    }

    if (Array.isArray(args)) {
        args = {
            section: args[0],
        }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
        section: typeof args.section === 'object'
        ? args.section.slug
        : args.section,
    }

    return show.definition.url
            .replace('{section}', parsedArgs.section.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\SectionController::show
* @see app/Http/Controllers/SectionController.php:88
* @route '/sections/{section}'
*/
show.get = (args: { section: string | number | { slug: string | number } } | [section: string | number | { slug: string | number } ] | string | number | { slug: string | number }, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SectionController::show
* @see app/Http/Controllers/SectionController.php:88
* @route '/sections/{section}'
*/
show.head = (args: { section: string | number | { slug: string | number } } | [section: string | number | { slug: string | number } ] | string | number | { slug: string | number }, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: show.url(args, options),
    method: 'head',
})

/**
* @see \App\Http\Controllers\SectionController::show
* @see app/Http/Controllers/SectionController.php:88
* @route '/sections/{section}'
*/
const showForm = (args: { section: string | number | { slug: string | number } } | [section: string | number | { slug: string | number } ] | string | number | { slug: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SectionController::show
* @see app/Http/Controllers/SectionController.php:88
* @route '/sections/{section}'
*/
showForm.get = (args: { section: string | number | { slug: string | number } } | [section: string | number | { slug: string | number } ] | string | number | { slug: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, options),
    method: 'get',
})

/**
* @see \App\Http\Controllers\SectionController::show
* @see app/Http/Controllers/SectionController.php:88
* @route '/sections/{section}'
*/
showForm.head = (args: { section: string | number | { slug: string | number } } | [section: string | number | { slug: string | number } ] | string | number | { slug: string | number }, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
    action: show.url(args, {
        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
            _method: 'HEAD',
            ...(options?.query ?? options?.mergeQuery ?? {}),
        }
    }),
    method: 'get',
})

show.form = showForm

const SectionController = { index, create, store, edit, update, resubmit, destroy, getCode, show }

export default SectionController