import { NavMain } from '@/components/nav-main';
import { NavUser } from '@/components/nav-user';
import { Sidebar, SidebarContent, SidebarFooter, SidebarHeader, SidebarMenu, SidebarMenuButton, SidebarMenuItem } from '@/components/ui/sidebar';
import { dashboard } from '@/routes';
import { type NavItem } from '@/types';
import { Link, usePage } from '@inertiajs/react';
import { CheckSquare, Folder, FolderTree, LayoutGrid, Package, Plus, Settings, Users } from 'lucide-react';
import AppLogo from './app-logo';

export function AppSidebar() {
    const page = usePage();
    const auth = (page.props as unknown as { auth: { user: { role: string } } }).auth;
    const userRole = auth?.user?.role || 'user';

    // Base navigation for all authenticated users
    const baseNavItems: NavItem[] = [
        {
            title: 'Dashboard',
            href: dashboard(),
            icon: LayoutGrid,
        },
        {
            title: 'Browse Components',
            href: '/sections',
            icon: Package,
        },
    ];

    // Contributor-specific navigation
    const contributorNavItems: NavItem[] = [
        {
            title: 'My Sections',
            href: '/my-sections',
            icon: Folder,
        },
        {
            title: 'Add New Section',
            href: '/sections/create',
            icon: Plus,
        },
        {
            title: 'Categories',
            href: '/admin/categories',
            icon: FolderTree,
        },
    ];

    // Admin-specific navigation
    const adminNavItems: NavItem[] = [
        {
            title: 'Manage Sections',
            href: '/admin/sections',
            icon: CheckSquare,
        },
        {
            title: 'Manage Users',
            href: '/admin/users',
            icon: Users,
        },
        {
            title: 'Settings',
            href: '/settings',
            icon: Settings,
        },
    ];

    // Combine navigation items based on role
    let mainNavItems = [...baseNavItems];

    if (userRole === 'contributor' || userRole === 'admin') {
        mainNavItems = [...mainNavItems, ...contributorNavItems];
    }

    if (userRole === 'admin') {
        mainNavItems = [...mainNavItems, ...adminNavItems];
    }



    return (
        <Sidebar collapsible="icon" variant="inset">
            <SidebarHeader>
                <SidebarMenu>
                    <SidebarMenuItem>
                        <SidebarMenuButton size="lg" asChild>
                            <Link href={dashboard()} prefetch>
                                <AppLogo />
                            </Link>
                        </SidebarMenuButton>
                    </SidebarMenuItem>
                </SidebarMenu>
            </SidebarHeader>

            <SidebarContent>
                <NavMain items={mainNavItems} />
            </SidebarContent>

            <SidebarFooter>
                <NavUser />
            </SidebarFooter>
        </Sidebar>
    );
}
