import {
    Accordion,
    AccordionContent,
    AccordionItem,
    AccordionTrigger,
} from '@/components/ui/accordion';
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card';
import AppLayout from '@/layouts/app-layout';
import { Head } from '@inertiajs/react';
import { BookOpen, Code, HelpCircle, Shield, Users } from 'lucide-react';

export default function Help() {
    return (
        <AppLayout>
            <Head title="Help & Documentation" />

            <div className="container mx-auto px-4 py-8 max-w-4xl">
                <div className="mb-8">
                    <h1 className="text-4xl font-bold mb-2">Help & Documentation</h1>
                    <p className="text-muted-foreground text-lg">
                        Everything you need to know about using Softihub
                    </p>
                </div>

                <div className="space-y-6">
                    {/* Getting Started */}
                    <Card>
                        <CardHeader>
                            <CardTitle className="flex items-center">
                                <BookOpen className="mr-2 h-5 w-5 text-blue-500" />
                                Getting Started
                            </CardTitle>
                            <CardDescription>
                                Learn the basics of using Softihub
                            </CardDescription>
                        </CardHeader>
                        <CardContent>
                            <Accordion type="single" collapsible className="w-full">
                                <AccordionItem value="item-1">
                                    <AccordionTrigger>What is Softihub?</AccordionTrigger>
                                    <AccordionContent>
                                        Softihub is a platform for developers to share and discover reusable
                                        code sections. You can browse sections by category, create your own
                                        sections, and manage different versions of your code.
                                    </AccordionContent>
                                </AccordionItem>

                                <AccordionItem value="item-2">
                                    <AccordionTrigger>How do I create an account?</AccordionTrigger>
                                    <AccordionContent>
                                        Account creation is managed by administrators. Contact an admin to
                                        request an account. Once created, you'll receive your login credentials
                                        via email.
                                    </AccordionContent>
                                </AccordionItem>

                                <AccordionItem value="item-3">
                                    <AccordionTrigger>What are the different user roles?</AccordionTrigger>
                                    <AccordionContent>
                                        <ul className="space-y-2">
                                            <li>
                                                <strong>User:</strong> Can browse and view sections
                                            </li>
                                            <li>
                                                <strong>Contributor:</strong> Can create and manage their own
                                                sections
                                            </li>
                                            <li>
                                                <strong>Admin:</strong> Full access including user management,
                                                section moderation, and category management
                                            </li>
                                        </ul>
                                    </AccordionContent>
                                </AccordionItem>
                            </Accordion>
                        </CardContent>
                    </Card>

                    {/* Managing Sections */}
                    <Card>
                        <CardHeader>
                            <CardTitle className="flex items-center">
                                <Code className="mr-2 h-5 w-5 text-green-500" />
                                Managing Sections
                            </CardTitle>
                            <CardDescription>
                                How to create and manage code sections
                            </CardDescription>
                        </CardHeader>
                        <CardContent>
                            <Accordion type="single" collapsible className="w-full">
                                <AccordionItem value="item-1">
                                    <AccordionTrigger>How do I create a section?</AccordionTrigger>
                                    <AccordionContent>
                                        <ol className="list-decimal list-inside space-y-2">
                                            <li>Navigate to "My Sections" from the sidebar</li>
                                            <li>Click "Create New Section"</li>
                                            <li>Fill in the title, description, and select a category</li>
                                            <li>Add your code in the code editor</li>
                                            <li>Submit for admin approval</li>
                                        </ol>
                                    </AccordionContent>
                                </AccordionItem>

                                <AccordionItem value="item-2">
                                    <AccordionTrigger>What happens after I submit a section?</AccordionTrigger>
                                    <AccordionContent>
                                        After submission, your section enters a "pending" state and waits for
                                        admin review. Admins can approve or reject your section. You'll be
                                        notified of the decision, and approved sections become publicly visible.
                                    </AccordionContent>
                                </AccordionItem>

                                <AccordionItem value="item-3">
                                    <AccordionTrigger>Can I edit my sections?</AccordionTrigger>
                                    <AccordionContent>
                                        Yes! You can edit your sections at any time. When you make changes,
                                        a new version is created. This allows you to maintain a history of
                                        changes and roll back if needed.
                                    </AccordionContent>
                                </AccordionItem>

                                <AccordionItem value="item-4">
                                    <AccordionTrigger>How do versions work?</AccordionTrigger>
                                    <AccordionContent>
                                        Each time you edit a section, a new version is automatically created.
                                        You can view all versions of a section and see what changed between
                                        versions. The latest approved version is shown to users by default.
                                    </AccordionContent>
                                </AccordionItem>
                            </Accordion>
                        </CardContent>
                    </Card>

                    {/* Admin Features */}
                    <Card>
                        <CardHeader>
                            <CardTitle className="flex items-center">
                                <Shield className="mr-2 h-5 w-5 text-red-500" />
                                Admin Features
                            </CardTitle>
                            <CardDescription>
                                Features available to administrators
                            </CardDescription>
                        </CardHeader>
                        <CardContent>
                            <Accordion type="single" collapsible className="w-full">
                                <AccordionItem value="item-1">
                                    <AccordionTrigger>How do I manage users?</AccordionTrigger>
                                    <AccordionContent>
                                        Navigate to "Manage Users" from the sidebar. Here you can:
                                        <ul className="mt-2 space-y-1 list-disc list-inside">
                                            <li>Create new user accounts</li>
                                            <li>Edit user information and roles</li>
                                            <li>Change user passwords</li>
                                            <li>Delete user accounts</li>
                                            <li>Search and filter users</li>
                                        </ul>
                                    </AccordionContent>
                                </AccordionItem>

                                <AccordionItem value="item-2">
                                    <AccordionTrigger>How do I moderate sections?</AccordionTrigger>
                                    <AccordionContent>
                                        Go to "Admin Sections" to see all pending sections. You can:
                                        <ul className="mt-2 space-y-1 list-disc list-inside">
                                            <li>Review section content and code</li>
                                            <li>Approve sections to make them public</li>
                                            <li>Reject sections with feedback</li>
                                            <li>Bulk approve/reject multiple sections</li>
                                            <li>Delete inappropriate sections</li>
                                        </ul>
                                    </AccordionContent>
                                </AccordionItem>

                                <AccordionItem value="item-3">
                                    <AccordionTrigger>How do I manage categories?</AccordionTrigger>
                                    <AccordionContent>
                                        Access the category management from the admin menu. You can create,
                                        edit, and delete categories. Categories help organize sections and
                                        make them easier to discover.
                                    </AccordionContent>
                                </AccordionItem>
                            </Accordion>
                        </CardContent>
                    </Card>

                    {/* Account & Settings */}
                    <Card>
                        <CardHeader>
                            <CardTitle className="flex items-center">
                                <Users className="mr-2 h-5 w-5 text-purple-500" />
                                Account & Settings
                            </CardTitle>
                            <CardDescription>
                                Managing your account and preferences
                            </CardDescription>
                        </CardHeader>
                        <CardContent>
                            <Accordion type="single" collapsible className="w-full">
                                <AccordionItem value="item-1">
                                    <AccordionTrigger>How do I change my password?</AccordionTrigger>
                                    <AccordionContent>
                                        Go to Settings → Password tab. Enter your current password and your
                                        new password twice to confirm. Click "Update Password" to save changes.
                                    </AccordionContent>
                                </AccordionItem>

                                <AccordionItem value="item-2">
                                    <AccordionTrigger>How do I update my profile?</AccordionTrigger>
                                    <AccordionContent>
                                        Navigate to Settings → Profile tab. Here you can update your name and
                                        email address. Your role can only be changed by an administrator.
                                    </AccordionContent>
                                </AccordionItem>

                                <AccordionItem value="item-3">
                                    <AccordionTrigger>Can I delete my account?</AccordionTrigger>
                                    <AccordionContent>
                                        Yes, but this action is permanent. Go to Settings → Account tab and
                                        follow the prompts. You'll need to confirm with your password. All
                                        your sections and data will be permanently deleted.
                                    </AccordionContent>
                                </AccordionItem>
                            </Accordion>
                        </CardContent>
                    </Card>

                    {/* Need More Help */}
                    <Card className="bg-muted/50">
                        <CardHeader>
                            <CardTitle className="flex items-center">
                                <HelpCircle className="mr-2 h-5 w-5" />
                                Still Need Help?
                            </CardTitle>
                        </CardHeader>
                        <CardContent>
                            <p className="text-muted-foreground">
                                If you couldn't find the answer to your question, please contact an
                                administrator or reach out to our support team. We're here to help!
                            </p>
                        </CardContent>
                    </Card>
                </div>
            </div>
        </AppLayout>
    );
}
