<?php


use Illuminate\Support\Facades\Route;


Route::get('/', function () {
    return auth('web')->check()
        ? redirect()->route('dashboard')
        : redirect()->route('login');
})->name('home');

Route::middleware(['auth', 'verified'])->group(function () {
    Route::get('dashboard', [\App\Http\Controllers\DashboardController::class, 'index'])->name('dashboard');

    // About page
    Route::get('about', function () {
        return \Inertia\Inertia::render('about');
    })->name('about');

    // Help page
    Route::get('help', function () {
        return \Inertia\Inertia::render('help');
    })->name('help');
});

require __DIR__ . '/settings.php';
require __DIR__ . '/sections.php';
